using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;

namespace VIRP.CRS.DAL
{
    public partial class USER_ROLESDB : DBUtils
    {
        #region Fields
        #endregion

        #region Constructors

        public USER_ROLESDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public USER_ROLES GetItemByUserIdRoleId(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 USER_ID, Int32 STD_ROLE_ID)
        {
            USER_ROLES objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_USER_ROLES_getitemByUserIdRoleId(CURRENT_USER, CURRENT_REGISTRY_ID, USER_ID, STD_ROLE_ID).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public USER_ROLES GetItemByUserRole(string Username, string RoleName)
        {
            USER_ROLES objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                    objReturn = dbContext.usp_USER_ROLES_getitemByUserRole(Username, RoleName).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                throw ex;
            }

            return objReturn;
        }

        public string[] GetRoles(string Username)
        {
            string[] objReturn = null;
            List<STD_ROLE> objTemp = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                    objTemp = dbContext.usp_USER_ROLES_getrolesByUser(Username).ToList();
                    if (objTemp != null)
                    {
                        foreach (STD_ROLE sr in objTemp)
                        {
                            if (!string.IsNullOrEmpty(sr.CODE))
                                AddToArray(ref objReturn, sr.CODE);
                        }
                    }
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                throw ex;
            }

            return objReturn;
        }

        public List<USER_ROLES> GetItemsByUser(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 USER_ID)
        {
            List<USER_ROLES> objReturn = null;

            //TODO: Revisit

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);

                    //objReturn = dbContext.usp_USER_ROLES_getitemsByUser(CURRENT_USER, CURRENT_REGISTRY_ID, USER_ID).ToList();
                    objReturn = dbContext.usp_USER_ROLES_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    objReturn = objReturn.Where(r => r.USER_ID == USER_ID).ToList();
                    LogManager.LogTiming(logDetails);

                    if (objReturn != null)
                    {
                        foreach (USER_ROLES ur in objReturn)
                        {
                            if (ur.STD_ROLE_ID > 0)
                                ur.STD_ROLE = dbContext.usp_STD_ROLE_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, ur.STD_ROLE_ID).FirstOrDefault();
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<USER_ROLES> GetItemsByUser(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, string Username)
        {
            List<USER_ROLES> objReturn = null;
            USERS objTemp = null;

            //TODO: Revisit

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);

                    //objReturn = dbContext.usp_USER_ROLES_getitemsByUsername(CURRENT_USER, CURRENT_REGISTRY_ID, Username).ToList();
                    objTemp = dbContext.usp_USERS_getitemByName(CURRENT_USER, CURRENT_REGISTRY_ID, Username).FirstOrDefault();
                    objReturn = dbContext.usp_USER_ROLES_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    objReturn = objReturn.Where(r => r.USER_ID == objTemp.USER_ID).ToList();

                    LogManager.LogTiming(logDetails);

                    if (objReturn != null)
                    {
                        foreach (USER_ROLES ur in objReturn)
                        {
                            if (ur.STD_ROLE_ID > 0)
                                ur.STD_ROLE = dbContext.usp_STD_ROLE_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, ur.STD_ROLE_ID).FirstOrDefault();
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public Boolean DeleteByUserRegistry(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 USER_ID, Int32 STD_REGISTRY_ID)
        {
            Boolean objReturn = false;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_USER_ROLES_deleteByUserRegistry(CURRENT_USER, CURRENT_REGISTRY_ID, USER_ID, STD_REGISTRY_ID);
                    objReturn = true;
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public Boolean SaveAll(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, List<USER_ROLES> USER_ROLES)
        {
            if (USER_ROLES == null)
                return false;

            Boolean objReturn = false;
            Int32? objTemp = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    foreach (USER_ROLES objSave in USER_ROLES)
                    {
                        objTemp = objSave.USER_ROLE_ID;
                        LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                        dbContext.usp_USER_ROLES_save(CURRENT_USER, CURRENT_REGISTRY_ID, DateTime.Now, objSave.CREATEDBY, objSave.INACTIVE_DATE, objSave.INACTIVE_FLAG, objSave.STD_ROLE_ID, DateTime.Now, objSave.UPDATEDBY, objSave.USER_ID, ref objTemp);
                        LogManager.LogTiming(logDetails);
                    }

                    objReturn = true;
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public USER_ROLES ParseReaderCustom(DataRow row)
        {
            USER_ROLES objReturn = new USER_ROLES
            {
                CREATED = row.Field<DateTime>("USER_ROLES_CREATED"),
                CREATEDBY = row.Field<string>("USER_ROLES_CREATEDBY"),
                INACTIVE_DATE = row.Field<DateTime?>("USER_ROLES_INACTIVE_DATE"),
                INACTIVE_FLAG = row.Field<bool>("USER_ROLES_INACTIVE_FLAG"),
                STD_ROLE_ID = row.Field<int>("USER_ROLES_STD_ROLE_ID"),
                UPDATED = row.Field<DateTime>("USER_ROLES_UPDATED"),
                UPDATEDBY = row.Field<string>("USER_ROLES_UPDATEDBY"),
                USER_ID = row.Field<int>("USER_ROLES_USER_ID"),
                USER_ROLE_ID = row.Field<int>("USER_ROLES_USER_ROLE_ID")
            };

            return objReturn;
        }

        public USER_ROLES ParseReaderComplete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, DataRow row)
        {
            USER_ROLES objReturn = ParseReaderCustom(row);

            if (objReturn != null)
            {
                STD_ROLEDB sTD_ROLEDB = new STD_ROLEDB();
                objReturn.STD_ROLE = sTD_ROLEDB.ParseReaderCustom(row);
            }

            return objReturn;
        }

        public List<string> GetRoleByRegistryId(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<string> objReturn = null;
            List<STD_ROLE> objTemp = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                    objTemp = dbContext.usp_USER_ROLES_getitemByRegistryIdUsername(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    if (objTemp != null)
                    {
                        objReturn = new List<string>();

                        foreach (STD_ROLE sr in objTemp)
                        {
                            if (!string.IsNullOrEmpty(sr.CODE))
                                objReturn.Add(sr.CODE);
                        }
                    }
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        #endregion
    }
}
